    @extends('admin.layouts.app')

    @section('title', 'Data Departemen')

    @section('content')

        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h4 class="fw-bold mb-1">Data Departemen</h4>
                <small class="text-muted">Manajemen Departemen</small>
            </div>

            <button class="btn btn-primary btn-sm d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#tambahDepartemen">
                <i class="fas fa-plus me-2"></i>Tambah Data
            </button>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-body">

                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Nama Departemen</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($departemen as $item)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->nama }}</td>
                                {{-- <td>
                                    <span class="badge bg-info text-dark">
                                        {{ $item->role }}
                                    </span>
                                </td> --}}


                                <td class="text-center">
                                    <button data-bs-target="#ubahDepartemen{{ $item->id }}" data-bs-toggle="modal"
                                        class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                        data-bs-target="#hapusDepartemen{{ $item->id }}">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

            </div>
            @foreach ($departemen as $item)
                @include('admin.departemen.edit')
                @include('admin.departemen.delete')
            @endforeach
        </div>
        @include('admin.departemen.create')


    @endsection
